"""
    Minimal demo using EZ_OpenGL_Frame.py
    
    Copyright (C) <2021> <Scorch>              
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Version 0.01
    - Initial code

"""
version = '0.01'
import sys
VERSION = sys.version_info[0]
if VERSION == 3:
    import tkinter as tk
else:
    import Tkinter as tk
    
from stl import mesh
from EZ_OpenGL_Frame import EZ_OpenGL_Frame

# GUI window is a subclass of the basic tkinter Frame object
class HelloWorldFrame(tk.Frame):
    def __init__(self, master):
        # Call superclass constructor
        tk.Frame.__init__(self, master)
        # Place frame into main window
        self.createwidgets()

    def createwidgets(self):
        ##########################################################################
        self.OpenGL_frame = EZ_OpenGL_Frame(self.master)
        self.OpenGL_frame.animate=1 #dont forget this, or your window will not animated
        self.master.update()
        w = int(self.master.winfo_width())
        h = int(self.master.winfo_height())
        self.OpenGL_frame.resize(w-20,w-20)    
        self.OpenGL_frame.place(x=10, y=10)

        self.OpenGL_frame.bind("<1>"     ,    self.LeftMouseClick)
        self.OpenGL_frame.bind("<B1-Motion>", self.LeftMouseMove)

        self.OpenGL_frame.bind("<2>"     ,    self.MiddleMouseClick)
        self.OpenGL_frame.bind("<B2-Motion>", self.MiddleMouseMove)
        
        self.OpenGL_frame.bind("<3>"     ,    self.RightMouseClick)
        self.OpenGL_frame.bind("<B3-Motion>", self.RightMouseMove)

        self.OpenGL_frame.bind('<MouseWheel>',    self.__wheel)  # zoom for Windows and MacOS, but not Linux
        self.OpenGL_frame.bind('<Button-5>',      self.__wheel)  # zoom for Linux, wheel scroll down
        self.OpenGL_frame.bind('<Button-4>',      self.__wheel)  # zoom for Linux, wheel scroll up

        ##########################################################################
        
        input_file = "view_cube.stl"
        your_mesh = mesh.Mesh.from_file(input_file)
        self.master.update()
        self.OpenGL_frame.STLmesh = your_mesh
        self.OpenGL_frame.update_VBO()

        self.OpenGL_frame.draw_edges = True
        self.OpenGL_frame.draw_box   = True
        self.OpenGL_frame.draw_axes  = True
        self.OpenGL_frame.set_tri_col(    (255,255,000,255) ) # Set triangle (surface) color
        self.OpenGL_frame.set_edge_col(   (200,200,000,255) ) # Set trinagle edge color
        self.OpenGL_frame.set_back_color( (000,000,000,255) ) # Set background color

        ## Use set_view with any of the folloing options to set the view orientation of the object
        self.OpenGL_frame.set_view("iso0") #Options: front, left, right top, bottom, back,
                                           #         iso0, iso1, iso2, iso3, iso4, iso5
        

        ##########################################################################
    def LeftMouseClick(self,event):
        self.pan_lastx = event.x
        self.pan_lasty = event.y
        
    def LeftMouseMove(self,event):
        x = event.x
        y = event.y
        self.OpenGL_frame.DH = self.OpenGL_frame.DH+(x-self.pan_lastx)
        self.OpenGL_frame.DV = self.OpenGL_frame.DV+(y-self.pan_lasty)
        self.pan_lastx = x
        self.pan_lasty = y

    def RightMouseClick(self,event):
        self.Rpan_lastx = event.x
        self.Rpan_lasty = event.y
        
    def RightMouseMove(self,event):
        x = event.x
        y = event.y
        self.OpenGL_frame.mPanX = self.OpenGL_frame.mPanX-float(x-self.Rpan_lastx)
        self.OpenGL_frame.mPanY = self.OpenGL_frame.mPanY+float(y-self.Rpan_lasty)
        self.Rpan_lastx = x
        self.Rpan_lasty = y

    def MiddleMouseClick(self,event):
        self.Mpan_lastx = event.x
        self.Mpan_lasty = event.y
        
    def MiddleMouseMove(self,event):
        y = event.y
        self.OpenGL_frame.Vscale = self.OpenGL_frame.Vscale+(y-self.Mpan_lasty)
        self.Mpan_lasty = y

    def __wheel(self, event):
        # mouse wheel
        #print(event.x,event.y,event.num,event.delta)
        # Respond to Linux (event.num) or Windows (event.delta) wheel event
        if event.num == 5 or event.delta == -120:  # scroll down, smaller
            self.OpenGL_frame.Vscale = self.OpenGL_frame.Vscale + 20
        if event.num == 4 or event.delta == 120:  # scroll up, bigger            
            self.OpenGL_frame.Vscale = self.OpenGL_frame.Vscale - 20
            
    ##########################################################################
# Spawn window
if __name__ == "__main__":
    root = tk.Tk()                      # Create main window object
    root.title("Minimal Demo")          # Set title of window
    root.minsize(600,600)
    hello_frame = HelloWorldFrame(root) # Instantiate HelloWorldFrame object
    # Start GUI
    hello_frame.mainloop()
    root.mainloop()
